/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultOccupancyCharts;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.chart.ui.ChartCanvas;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.chart.GridBoundOccupancyChart;
import com.nvidia.viper.ui.chart.RegisterBoundOccupancyChart;
import com.nvidia.viper.ui.chart.SharedMemoryBoundOccupancyChart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class KernelOccupancyChartsControl
extends AnalysisResultControl {
    public KernelOccupancyChartsControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session, false);
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        Control charts = this.createCharts(parent);
        charts.setLayoutData((Object)new GridData(1808));
    }

    private Control createCharts(Composite parent) {
        SashForm pane = new SashForm(parent, 0);
        ChartCanvas grid = new ChartCanvas((Composite)pane, 0);
        ChartCanvas registers = new ChartCanvas((Composite)pane, 0);
        ChartCanvas sharedMemory = new ChartCanvas((Composite)pane, 0);
        try {
            TimelineIntervalKernel kernel = this.getResult().getKernel();
            OccupancyCalculator calculator = this.getResult().getOccupancyCalculator();
            OccupancyCalculator.Limiter limiter = calculator.getLimiter();
            grid.setChart((IViperChart)new GridBoundOccupancyChart(kernel, calculator, limiter == OccupancyCalculator.Limiter.BLOCK));
            registers.setChart((IViperChart)new RegisterBoundOccupancyChart(kernel, calculator, limiter == OccupancyCalculator.Limiter.REGISTER));
            sharedMemory.setChart((IViperChart)new SharedMemoryBoundOccupancyChart(kernel, calculator, limiter == OccupancyCalculator.Limiter.SHARED_MEMORY));
        }
        catch (ViperException e) {
            ViperExceptionHandler.logError("Cannot create occupancy/grid size chart", e);
        }
        return pane;
    }

    private AnalysisResultOccupancyCharts getResult() {
        return (AnalysisResultOccupancyCharts)this.result;
    }
}

